import { StarXpandCommand } from "star-io10-web";

export class ReceiptSample09_Order1_Template {
  static async createTemplate(): Promise<string> {
    let builder = new StarXpandCommand.StarXpandCommandBuilder();

    builder.addDocument(
      new StarXpandCommand.DocumentBuilder()
        .settingPrintableArea(72.0)
        .addPrinter(
          new StarXpandCommand.PrinterBuilder()
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleAlignment(StarXpandCommand.Printer.Alignment.Center)
                .styleLineSpace(0.0)
                .styleMagnification(
                  new StarXpandCommand.MagnificationParameter(2, 2),
                )
                .actionPrintText("${header}\n")
                .styleBold(true)
                .styleInvert(true)
                .actionPrintText(
                  "${title}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    24,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Center,
                    ),
                  ),
                ),
            )
            .actionFeed(2.0)
            .actionPrintText(
              "#${number}",
              new StarXpandCommand.Printer.TextParameter().setWidth(10),
            )
            .actionPrintText(
              "${datetime}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                38,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .styleBold(true)
            .actionPrintText(
              "${store_name}",
              new StarXpandCommand.Printer.TextParameter().setWidth(20),
            )
            .styleBold(false)
            .actionPrintText(
              "${order_number}\n",
              new StarXpandCommand.Printer.TextParameter().setWidth(
                28,
                new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                  StarXpandCommand.Printer.TextAlignment.Right,
                ),
              ),
            )
            .actionPrintText("${customer_name}\n")
            .actionFeedLine(1)
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(72.0),
            )
            .add(
              new StarXpandCommand.PrinterBuilder()
                .styleBold(true)
                .actionPrintText("# Item")
                .actionPrintText(
                  "Cst.#\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    42,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .add(
              new StarXpandCommand.PrinterBuilder(
                new StarXpandCommand.Printer.PrinterParameter().setTemplateExtension(
                  new StarXpandCommand.TemplateExtensionParameter().setEnableArrayFieldData(
                    true,
                  ),
                ),
              )
                .actionPrintText(
                  "${item_list.quantity}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(2),
                )
                .actionPrintText(
                  "${item_list.name}",
                  new StarXpandCommand.Printer.TextParameter().setWidth(41),
                )
                .actionPrintText(
                  "${item_list.cost}\n",
                  new StarXpandCommand.Printer.TextParameter().setWidth(
                    5,
                    new StarXpandCommand.Printer.TextWidthParameter().setAlignment(
                      StarXpandCommand.Printer.TextAlignment.Right,
                    ),
                  ),
                ),
            )
            .actionPrintRuledLine(
              new StarXpandCommand.Printer.RuledLineParameter(72.0),
            )
            .actionCut(StarXpandCommand.Printer.CutType.Partial),
        ),
    );
    return await builder.getCommands();
  }

  static async getFieldData(): Promise<string> {
    return Promise.resolve(
      `{
    "header" : "C8",
    "title" : "29",
    "number" : 1,
    "datetime" : "05/12/2022 09:48 AM",
    "store_name" : "StarShop",
    "order_number" : "152379515",
    "customer_name" : "John Smith",
    "item_list" : [
        {
            "quantity" : "1",
            "name" : "Cobb Salad",
            "cost" : "0"
        },
        {
            "quantity" : "1",
            "name" : "Pizza",
            "cost" : "0"
        },
        {
            "quantity" : "-1",
            "name" : "Cornish Game Hen",
            "cost" : "0"
        },
        {
            "quantity" : "",
            "name" : "*Extra toppings: El Atomico",
            "cost" : ""
        },
        {
            "quantity" : "1",
            "name" : "Big Salad",
            "cost" : "0"
        }
    ]
}`,
    );
  }
}
